classdef enum_engine_combustion_type < Simulink.IntEnumType
    enumeration
        compression_ignition(0)
        spark_ignition(1)
    end
    
     methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
